/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;

public class PdfSmartCopy
extends PdfCopy {
    private HashMap<ByteStore, PdfIndirectReference> streamMap = new HashMap();

    public PdfSmartCopy(Document document, OutputStream os) throws DocumentException {
        super(document, os);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfObject type;
        PdfIndirectReference theRef;
        PdfCopy.RefKey key;
        PdfCopy.IndirectReferences iRef;
        PdfObject srcObj = PdfReader.getPdfObjectRelease(in);
        ByteStore streamKey = null;
        boolean validStream = false;
        if (srcObj.isStream()) {
            streamKey = new ByteStore((PRStream)srcObj);
            validStream = true;
            PdfIndirectReference streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef;
            }
        }
        if ((iRef = (PdfCopy.IndirectReferences)this.indirects.get(key = new PdfCopy.RefKey(in))) != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new PdfCopy.IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        if (srcObj.isDictionary() && (type = PdfReader.getPdfObjectRelease(((PdfDictionary)srcObj).get(PdfName.TYPE))) != null && PdfName.PAGE.equals(type)) {
            return theRef;
        }
        iRef.setCopied();
        if (validStream) {
            this.streamMap.put(streamKey, theRef);
        }
        PdfObject obj = this.copyObject(srcObj);
        this.addToBody(obj, theRef);
        return theRef;
    }

    static class ByteStore {
        private byte[] b;
        private int hash;
        private MessageDigest md5;

        private void serObject(PdfObject obj, int level, ByteBuffer bb) throws IOException {
            if (level <= 0) {
                return;
            }
            if (obj == null) {
                bb.append("$Lnull");
                return;
            }
            if ((obj = PdfReader.getPdfObject(obj)).isStream()) {
                bb.append("$B");
                this.serDic((PdfDictionary)obj, level - 1, bb);
                if (level > 0) {
                    this.md5.reset();
                    bb.append(this.md5.digest(PdfReader.getStreamBytesRaw((PRStream)obj)));
                }
            } else if (obj.isDictionary()) {
                this.serDic((PdfDictionary)obj, level - 1, bb);
            } else if (obj.isArray()) {
                this.serArray((PdfArray)obj, level - 1, bb);
            } else if (obj.isString()) {
                bb.append("$S").append(obj.toString());
            } else if (obj.isName()) {
                bb.append("$N").append(obj.toString());
            } else {
                bb.append("$L").append(obj.toString());
            }
        }

        private void serDic(PdfDictionary dic, int level, ByteBuffer bb) throws IOException {
            bb.append("$D");
            if (level <= 0) {
                return;
            }
            Object[] keys = dic.getKeys().toArray();
            Arrays.sort(keys);
            for (int k = 0; k < keys.length; ++k) {
                this.serObject((PdfObject)keys[k], level, bb);
                this.serObject(dic.get((PdfName)keys[k]), level, bb);
            }
        }

        private void serArray(PdfArray array, int level, ByteBuffer bb) throws IOException {
            bb.append("$A");
            if (level <= 0) {
                return;
            }
            for (int k = 0; k < array.size(); ++k) {
                this.serObject(array.getPdfObject(k), level, bb);
            }
        }

        ByteStore(PRStream str) throws IOException {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
            ByteBuffer bb = new ByteBuffer();
            int level = 100;
            this.serObject(str, level, bb);
            this.b = bb.toByteArray();
            this.md5 = null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ByteStore)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return Arrays.equals(this.b, ((ByteStore)obj).b);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int len = this.b.length;
                for (int k = 0; k < len; ++k) {
                    this.hash = this.hash * 31 + (this.b[k] & 0xFF);
                }
            }
            return this.hash;
        }
    }
}

